package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.utility.DateHelper;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "PATIENT_EDIPI_ICN")
@XStreamAlias("PatientEdipiIcn")
public class PatientEdipiIcnPo extends PersistenceObject implements Transformable<PatientEdipiIcn> {

	private static final long serialVersionUID = -7727625724488456191L;

	@Id
	@GeneratedValue(generator = "id_generator")
	@GenericGenerator(name = "id_generator", strategy = "uuid")
	@Column(name = "ID", nullable = false)
	private String id;
	
	@Column(name = "EDIPI", nullable = false)
	private String edipi;
	
	@Column(name = "ICN", nullable = false)
	private String icn;
	
	 @Column(name = "ACTIVE")
	private boolean activeFlag = true;

	 @Column(name = "CREATED_DATE")
	private Date createdDate;
	 
	public PatientEdipiIcnPo() {
	}

	public PatientEdipiIcnPo(PatientEdipiIcn dto) {
		setId(dto.getId());
		setEdipi(dto.getEdipi());
		setIcn(dto.getIcn());
		setActiveFlag(dto.isActiveFlag());
		setCreatedDate(DateHelper.getToday());
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getEdipi() {
		return edipi;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	@Column(name = "ICN", nullable = false)
	public String getIcn() {
		return icn;
	}

	public void setEdipi(String edipi) {
		this.edipi = edipi;
	}
	
	public boolean isActiveFlag() {
		return activeFlag;
	}
	
	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public PatientEdipiIcn create() {
		PatientEdipiIcn dto = new PatientEdipiIcn();
		
		dto.setId(getId());
		dto.setEdipi(getEdipi());
		dto.setIcn(getIcn());
		dto.setActiveFlag(isActiveFlag());
		dto.setCreatedDate(getCreatedDate());
		
		return dto;
	}
	
}
