package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import javax.annotation.Resource;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoals.PainGoalsDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.utility.*;

public class PainGoalsDataLayerRepo implements PainGoalsDataLayer {

	String CompletedPercent = "100";

	@Resource
	PainGoalDao dao;
	@Resource
	PainGoalEntriesDao entriesDao;
	
	@Override
	public PainGoals fetchPainGoals(String patientId) {
		return dao.getPainGoals(patientId);
	}

    @Override
    public PainGoals fetchPainGoals(String patientId, DateFilter dateFilter) {
        PainGoals goals = dao.getPainGoals(patientId);
        return DateFilterer.filterByDate(goals, dateFilter);
    }

    @Override
	public PainGoal getPainGoal(String patientId, String dataId) {
    	return dao.getPainGoal(patientId, dataId);
	}
    
    @Override
	public PainGoal createNewPainGoal(PainGoal data) {
		if (NullChecker.isNullish(data.getUniqueId())) {
			setInitialGoalConfiguration(data);
		}
	
		return dao.createOrUpdateNewPainGoal(data);
	}

	private void setInitialGoalConfiguration(PainGoal data) {
		
		data.setDateStarted(DateHelper.getToday());

		if (CompletedPercent.equalsIgnoreCase(data.getPercentComplete()) && data.getStatus() == PainGoalStatus.PainGoalStatusActive) {
			data.setStatus(PainGoalStatus.PainGoalStatusComplete);
		} else {
			data.setStatus(PainGoalStatus.PainGoalStatusActive);
		}
		
	}

	@Override
	public PainGoal updatePainGoal(PainGoal data) {
		
		if (CompletedPercent.equalsIgnoreCase(data.getPercentComplete())) {
			data.setStatus(PainGoalStatus.PainGoalStatusComplete);
			
			if (NullChecker.isNullish(data.getDateCompleted())) {
				data.setDateCompleted(DateHelper.getToday());
			}
		} else if (PainGoalStatus.PainGoalStatusDeleted.toString().equalsIgnoreCase(data.getStatus().toString())) {
		
			if (NullChecker.isNullish(data.getDateDeleted())) {
				data.setDateDeleted(DateHelper.getToday());
			}
		} else {
		
			data.setStatus(PainGoalStatus.PainGoalStatusActive);
		}
		
		return dao.createOrUpdateNewPainGoal(data);
	}

	@Override
	public PainGoals fetchAllPainGoals(String patientId) {
	    return dao.getAllPainGoals(patientId);
	}

    @Override
    public PainGoals fetchAllPainGoals(String patientId, DateFilter dateFilter) {
        PainGoals goals = dao.getAllPainGoals(patientId);
        return DateFilterer.filterByDate(goals, dateFilter);
    }

    @Override
	public PainGoalEntries fetchAllPainGoalEntries(String patientId, DataIdentifier dataIdentifier) {
		return entriesDao.getAllPainGoalEntries(patientId, dataIdentifier);
	}

	@Override
	public PainGoalEntry createNewPainGoalEntry(PainGoalEntry data, String goalId) {
		data.setEntryDate(DateHelper.getToday());
		
		return entriesDao.createOrUpdatePainGoalEntry(data, goalId);
	}

	@Override
	public PainGoalEntry updatePainGoalEntry(PainGoalEntry data, String goalId) {
		return entriesDao.createOrUpdatePainGoalEntry(data, goalId);
	}

	@Override
	public void deletePainGoalEntry(PainGoalEntry data, String goalId) {
		entriesDao.deletePainGoalEntry(data, goalId);
	}

	@Override
	public void deletePainGoal(PainGoal data) {
		dao.deletePainGoal(data);
	}
}
