package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import java.util.*;
import javax.persistence.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;

import org.hibernate.annotations.GenericGenerator;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.*;

@Entity
@Table(name = PainGoalPo.TABLE_NAME)
@XStreamAlias("PainGoal")
public class PainGoalPo extends PersistenceObject implements Transformable<PainGoal> {

	private static final long serialVersionUID = 5267112213165310987L;
    public static final String TABLE_NAME = "PAIN_GOALS";

    private String name;
	private String status;
	private Date dateStarted = null;
	private Date targetDate = null;
	private Date dateCompleted = null;
	private Date dateDeleted = null;
	private String percentComplete;
	private String goalType;
	private String details;
	private String nextActionStep;
		
	@XStreamImplicit(itemFieldName="PainGoalEntries")
	private List<PainGoalEntryPo> painGoalEntries;

	public PainGoalPo() {}
	
	public PainGoalPo(PainGoal dto) {
		setId(dto.getUniqueId());
		setUserId(dto.getPatientId());
		
		name = dto.getName();
		status = dto.getStatus().toString();
		dateStarted = dto.getDateStarted();
		targetDate = dto.getTargetDate();
		percentComplete = dto.getPercentComplete();
		goalType = dto.getGoalType();
		details = dto.getDetails();
		nextActionStep = dto.getNextActionStep();
		dateDeleted = dto.getDateDeleted();
		dateCompleted = dto.getDateCompleted();
		
		if (NullChecker.isNotNullish(dto.getPainGoalEntries()))
			painGoalEntries = createGoalEntriesPoList(dto.getPainGoalEntries());
	}
	
	private List<PainGoalEntryPo> createGoalEntriesPoList(PainGoalEntries dtoPainGoalEntries) {
		List<PainGoalEntryPo> goalEntriesPO = new ArrayList<PainGoalEntryPo>();
		
		for (PainGoalEntry entry : dtoPainGoalEntries) {
			PainGoalEntryPo entryPo = new PainGoalEntryPo();
			entryPo.setComments(entry.getComments());
			entryPo.setEntryDate(entry.getEntryDate());
			entryPo.setGoal(this);
			entryPo.setId(entry.getUniqueId());
			entryPo.setPercentComplete(entry.getPercentComplete());
			entryPo.setStatus(entry.getStatus().toString());
			
			goalEntriesPO.add(entryPo);
			
		}
		
		return goalEntriesPO;
	}

	@Id
	@GeneratedValue(generator = "pain_goal_id_generator")
	@GenericGenerator(name = "pain_goal_id_generator", strategy = "uuid")
	@Column(name = "PAIN_GOAL_ID", nullable = false)
	public String getId() {
		return super.getId();
	}
	
	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}
	
	@Column(name = "NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "GOAL_STATUS")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name = "DATE_STARTED")
	public Date getDateStarted() {
		return dateStarted;
	}

	public void setDateStarted(Date dateStarted) {
		this.dateStarted = dateStarted;
	}
	
	@Column(name = "DATE_COMPLETED")
	public Date getDateCompleted() {
		return dateCompleted;
	}

	public void setDateCompleted(Date dateCompleted) {
		this.dateCompleted = dateCompleted;
	}
	
	@Column(name = "DATE_DELETED")
	public Date getDateDeleted() {
		return dateDeleted;
	}

	public void setDateDeleted(Date dateDeleted) {
		this.dateDeleted = dateDeleted;
	}
	
	@Column(name = "TARGET_DATE")
	public Date getTargetDate() {
		return targetDate;
	}

	public void setTargetDate(Date targetDate) {
		this.targetDate = targetDate;
	}

	@Column(name = "PERCENT_COMPLETE")
	public String getPercentComplete() {
		return percentComplete;
	}

	public void setPercentComplete(String percentComplete) {
		this.percentComplete = percentComplete;
	}
	
	@Column(name = "GOAL_TYPE")
	public String getGoalType() {
		return goalType;
	}

	public void setGoalType(String goalType) {
		this.goalType = goalType;
	}

	@Column(name = "DETAILS")
	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	@Column(name = "NEXT_ACTION_STEP")
	public String getNextActionStep() {
		return nextActionStep;
	}

	public void setNextActionStep(String nextActionStep) {
		this.nextActionStep = nextActionStep;
	}
	
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "goal")
	public List<PainGoalEntryPo> getPainGoalEntries() {
		return painGoalEntries;
	}

	public void setPainGoalEntries(List<PainGoalEntryPo> painGoalEntries) {
		this.painGoalEntries = painGoalEntries;
	}

	@Override
	public PainGoal create() {
		PainGoal dto = new PainGoal();
		
		dto.setUniqueId(getId());
		dto.setPatientId(getUserId());
				
		dto.setName(name);
		dto.setStatus(PainGoalStatus.fromValue(status));
		dto.setDateStarted(dateStarted);
		dto.setTargetDate(targetDate);
		dto.setPercentComplete(percentComplete);
		dto.setGoalType(goalType);
		dto.setDetails(details);
		dto.setNextActionStep(nextActionStep);
		dto.setDateCompleted(dateCompleted);
		dto.setDateDeleted(dateDeleted);
		
		if (NullChecker.isNotNullish(painGoalEntries)) {
			dto.setPainGoalEntries(createGoalEntriesDto());
		}
		
		return dto;
	}

	private PainGoalEntries createGoalEntriesDto() {

		PainGoalEntries dtoEntries = new PainGoalEntries();
		
		for (PainGoalEntryPo po : painGoalEntries) {
			
			PainGoalEntry dto = new PainGoalEntry();
			dto.setComments(po.getComments());
			dto.setEntryDate(po.getEntryDate());
			dto.setPercentComplete(po.getPercentComplete());
			dto.setPatientId(po.getUserId());
			dto.setUniqueId(po.getId());
			dto.setStatus(PainGoalEntryStatus.fromValue(po.getStatus()));
			
			dtoEntries.add(dto);
		}

		return dtoEntries;
	}

}
