package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import java.util.Date;
import javax.persistence.*;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;
import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoalEntry;
import com.agilex.healthcare.utility.PainGoalEntryStatus;

@Entity
@Table(name = PainGoalEntryPo.TABLE_NAME)
@XStreamAlias("PainGoalEntry")
public class PainGoalEntryPo extends PersistenceObject implements Transformable<PainGoalEntry> {

	private static final long serialVersionUID = -3975190023487978181L;
    public static final String TABLE_NAME = "PAIN_GOAL_ENTRIES";

    private String comments;
	private Date entryDate;
	private String percentComplete;
	private PainGoalPo goal;
	private String status;
	

	public PainGoalEntryPo() {}
	
	public PainGoalEntryPo(PainGoalEntry dto, PainGoalPo goalPo) {
		
		setId(dto.getUniqueId());
		setUserId(dto.getPatientId());
		
		comments = dto.getComments();
		status = dto.getStatus().toString();
		entryDate = dto.getEntryDate();
		percentComplete = dto.getPercentComplete();		
		goal = goalPo;
	}
	
	@Id
	@GeneratedValue(generator = "pain_goal_entry_id_generator")
	@GenericGenerator(name = "pain_goal_entry_id_generator", strategy = "uuid")
	@Column(name = "PAIN_GOAL_ENTRY_ID", nullable = false)
	public String getId() {
		return super.getId();
	}
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PAIN_GOAL_ID", nullable = false)
	public PainGoalPo getGoal() {
		return goal;
	}
	public void setGoal(PainGoalPo goal) {
		this.goal = goal;
	}
	
	@Column(name = "COMMENTS")
	public String getComments() {
		return comments;
	}
	
	public void setComments(String comments) {
		this.comments = comments;
	}
	
	@Column(name = "ENTRY_DATE")
	public Date getEntryDate() {
		return entryDate;
	}
	
	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	@Column(name = "PERCENT_COMPLETE")
	public String getPercentComplete() {
		return percentComplete;
	}

	public void setPercentComplete(String percentComplete) {
		this.percentComplete = percentComplete;
	}
	
	@Column(name = "STATUS")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Override
	public PainGoalEntry create() {

		PainGoalEntry dto = new PainGoalEntry();
		
		dto.setUniqueId(getId());
		dto.setPatientId(getUserId());
				
		dto.setComments(comments);
		dto.setStatus(PainGoalEntryStatus.fromValue(status));
		dto.setEntryDate(entryDate);
		dto.setPercentComplete(percentComplete);
		
		return dto;
	}
	
	
	
}
