package com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal;

import java.util.*;
import javax.persistence.TypedQuery;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.NullChecker;

@Repository
public class PainGoalEntriesDao extends AbstractDao {
	
	public PainGoalEntries getAllPainGoalEntries(String patientId, DataIdentifier painGoalIdentifier) {
		TypedQuery<PainGoalEntryPo> constructedQuery = this.constructPainGoalEntryWhereClause(painGoalIdentifier);
		
		PainGoalEntries entries = executeAndFetchEntries(constructedQuery);		
        
        return entries;
	}
	
	private PainGoalEntries executeAndFetchEntries(TypedQuery<PainGoalEntryPo> constructedQuery) {
		List<PainGoalEntryPo> entriesPo = this.executeForPainGoalEntriess(constructedQuery);
		
        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(entriesPo);
        PainGoalEntries entries = new PainGoalEntries();
        Mapper.add(transformableList, entries);
		
        return entries;
	}

	private List<PainGoalEntryPo> executeForPainGoalEntriess(TypedQuery<PainGoalEntryPo> constructedQuery) {
		return constructedQuery.getResultList();
	}

	private TypedQuery<PainGoalEntryPo> constructPainGoalEntryWhereClause(DataIdentifier painGoalID) {
		Map<String, Object> parameters = new HashMap<String, Object>();
		parameters.put("painGoalId", painGoalID.getUniqueId());
		
		String query = "from PainGoalEntryPo entry where entry.goal.id = :painGoalId";
		
		TypedQuery<PainGoalEntryPo> constructedQuery = this.setParametersForPainGoalEntriesQuery(query, parameters);
		return constructedQuery;
	}
	
	private TypedQuery<PainGoalEntryPo> setParametersForPainGoalEntriesQuery(String query, Map<String, Object> parameters) {
		TypedQuery<PainGoalEntryPo> constructedQuery = this.entityManager.createQuery(query, PainGoalEntryPo.class);
		for (String key : parameters.keySet()) {
			constructedQuery.setParameter(key, parameters.get(key));
		}
		return constructedQuery;
	}
	
	private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<PainGoalEntryPo> entriesPo) {
		 List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
	        transformableList.addAll(entriesPo);	
	
	     return transformableList;
	}


	@Transactional(propagation = Propagation.REQUIRED)
	public PainGoalEntry createOrUpdatePainGoalEntry(PainGoalEntry data, String goalId) {
	
		PainGoalEntryPo goalEntryPoToSave = new PainGoalEntryPo(data, null);

        if (NullChecker.isNotNullish(goalId)) {
            PainGoalPo existingPo = this.entityManager.find(PainGoalPo.class, goalId);
            if (existingPo != null) {
                goalEntryPoToSave = new PainGoalEntryPo(data, existingPo);

            }
        }

        UserHistoryEntityManager<PainGoalEntryPo> simpleEntityManager = new UserHistoryEntityManager<PainGoalEntryPo>(entityManager, PainGoalEntryPo.TABLE_NAME, data);
        PainGoalEntryPo po = simpleEntityManager.save(goalEntryPoToSave);

		return po.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void deletePainGoalEntry(PainGoalEntry data, String goalId) {
		
		PainGoalPo existingGoalPo = this.entityManager.find(PainGoalPo.class, goalId);
		
		PainGoalEntryPo matchToDelete = null;
		
		for (PainGoalEntryPo entryPo : existingGoalPo.getPainGoalEntries()) {
			if (data.getUniqueId().equalsIgnoreCase(entryPo.getId())) {
				matchToDelete = entryPo;
			}
		}
		
		if (matchToDelete != null) {
			existingGoalPo.getPainGoalEntries().remove(matchToDelete);
		}

		this.entityManager.merge(existingGoalPo);	

        UserHistoryEntityManager<PainGoalEntryPo> simpleEntityManager = new UserHistoryEntityManager<PainGoalEntryPo>(entityManager, PainGoalEntryPo.TABLE_NAME);
        simpleEntityManager.delete(data, PainGoalEntryPo.class);
	}
	
}
