package com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "RESPONSES")
@XStreamAlias("PainDiaryResponse")
public class PainDiaryResponsePo extends PersistenceObject {

	private static final long serialVersionUID = 3412192039951024652L;

	private String response;
	private PainDiaryEntryPo entry;
	private String questionId;

	@Id
	@GeneratedValue(generator = "pain_response_id_generator")
	@GenericGenerator(name = "pain_response_id_generator", strategy = "uuid")
	@Column(name = "RESPONSE_ID", nullable = false)
	public String getId() {
		return super.getId();
	}
	
	@Column(name = "RESPONSE")
	public String getResponse() {
		return response;
	}
	public void setResponse(String response) {
		this.response = response;
	}
	
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "ENTRY_ID", nullable = false)
	public PainDiaryEntryPo getEntry() {
		return entry;
	}
	public void setEntry(PainDiaryEntryPo entry) {
		this.entry = entry;
	}

	@Column(name = "QUESTION_ID")
	public String getQuestionId() {
		return questionId;
	}

	public void setQuestionId(String questionId) {
		this.questionId = questionId;
	}

	
}
