package com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryDao;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class PainDiaryEntryDataLayerRepo implements PainDiaryDataLayer {

	@Resource
	PainDiaryEntryDao dao;
	

	@Override
	public PainDiaryEntries fetchPainDiaryEntries(String patientId) {
		return dao.getPainDiaryEntries(patientId);
	}
	@Override
	public PainDiaryEntries fetchPainDiaryEntries(String patientId,
			DateFilter dateFilter) {
		PainDiaryEntries fetchedResults = fetchPainDiaryEntries(patientId);
		return DateFilterer.filterByDate(fetchedResults, dateFilter);
	}
	@Override
	public PainDiaryEntry fetchPainDiaryEntry(String patientId, String dataId) {
		return dao.getPainDiaryEntry(patientId, dataId);
	}

	@Override
	public PainDiaryEntry createNewPainDiaryEntry(PainDiaryEntry data) {
		if (NullChecker.isNullish(data.getUniqueId())) {
			setInitialEntryConfiguration(data);
		}
	
		return dao.createNewPainDiaryEntry(data);
	}

	private void setInitialEntryConfiguration(PainDiaryEntry data) {
		
		data.setDateCreated(DateHelper.getToday());
		
		if (data.isCompleted() && NullChecker.isNullish(data.getDateCompleted())) {
			data.setDateCompleted(DateHelper.getToday());
		}
	}

	@Override
	public PainDiaryEntry updatePainDiaryEntry(PainDiaryEntry data) {
		return dao.updatePainDiaryEntry(data);
	}


	
	
}
