package com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary;

import java.util.*;
import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.validPo;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.*;

@Repository
public class PainDiaryEntryDao extends AbstractDao {


	public PainDiaryEntries getPainDiaryEntries(String patientId) {
		TypedQuery<PainDiaryEntryPo> constructedQuery = this.constructWhereClause(patientId);
		
		List<PainDiaryEntryPo> entriesPo = this.executeForPainDiaryEntries(constructedQuery);
		
        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(entriesPo);
        PainDiaryEntries entries = new PainDiaryEntries();
        Mapper.add(transformableList, entries);
		
		return entries;
	}
	
	 private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<PainDiaryEntryPo> results) {
         List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }
	 
	private List<PainDiaryEntryPo> executeForPainDiaryEntries(TypedQuery<PainDiaryEntryPo> constructedQuery) {
		return constructedQuery.getResultList();
	}

	private TypedQuery<PainDiaryEntryPo> constructWhereClause(String patientId) {
		Map<String, Object> parameters = new HashMap<String, Object>();
		parameters.put("patientId", patientId);
		
		String query = "from PainDiaryEntryPo painDiaryEntry where painDiaryEntry.userId = :patientId";
		TypedQuery<PainDiaryEntryPo> constructedQuery = this.setParametersForQuery(query, parameters);
		return constructedQuery;
	}

	private TypedQuery<PainDiaryEntryPo> setParametersForQuery(String query, Map<String, Object> parameters) {
		TypedQuery<PainDiaryEntryPo> constructedQuery = this.entityManager.createQuery(query, PainDiaryEntryPo.class);
		for (String key : parameters.keySet()) {
			constructedQuery.setParameter(key, parameters.get(key));
		}
		return constructedQuery;
	}

	public PainDiaryEntry getPainDiaryEntry(String patientId, String dataId) {
		String queryStringForId = "from PainDiaryEntryPo painDiaryEntry where painDiaryEntry.userId = :patientId and painDiaryEntry.id = :dataId";
		Map<String, Object> parameters = new HashMap<String, Object>();
		parameters.put("patientId", patientId);
		parameters.put("dataId", dataId);
		
		TypedQuery<PainDiaryEntryPo> constructedQuery = this.setParametersForQuery(queryStringForId, parameters);
		
		return this.executeForPainDiaryEntry(constructedQuery).create();
	}

	private PainDiaryEntryPo executeForPainDiaryEntry(TypedQuery<PainDiaryEntryPo> constructedQuery) {
		List<PainDiaryEntryPo> results = constructedQuery.getResultList();
		if (results.size() > 0) {
			return results.get(0);
		} else {
			return new PainDiaryEntryPo();
		}
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public PainDiaryEntry createNewPainDiaryEntry(PainDiaryEntry newPainDiaryEntry) {
        UserHistoryEntityManager<PainDiaryEntryPo> simpleEntityManager = new UserHistoryEntityManager<PainDiaryEntryPo>(entityManager, PainDiaryEntryPo.TABLE_NAME, newPainDiaryEntry);
        PainDiaryEntryPo po = simpleEntityManager.save(new PainDiaryEntryPo(newPainDiaryEntry));

		return po.create();
	}


	@Transactional(propagation = Propagation.REQUIRED)
	public PainDiaryEntry updatePainDiaryEntry(PainDiaryEntry painDiaryEntry) {
		validPo<PainDiaryEntryPo> validPo = new validPo<PainDiaryEntryPo>(entityManager, new PainDiaryEntryPo(painDiaryEntry));
		if (!validPo.isOk()) {
			return null;
		}

		String query = "delete from PainDiaryResponsePo response where response.entry = :entry";
		Map<String, Object> parameters = new HashMap<String, Object>();
		parameters.put("entry", new PainDiaryEntryPo(painDiaryEntry));
		
		Query constructedQuery = this.setParametersForResponseQuery(query, parameters);
		this.executeForPainDiaryResponse(constructedQuery);

        UserHistoryEntityManager<PainDiaryEntryPo> simpleEntityManager = new UserHistoryEntityManager<PainDiaryEntryPo>(entityManager, PainDiaryEntryPo.TABLE_NAME, painDiaryEntry);
        PainDiaryEntryPo po = simpleEntityManager.save(new PainDiaryEntryPo(painDiaryEntry));

        return po.create();
    }
	
	private Query setParametersForResponseQuery(String query, Map<String, Object> parameters) {
		Query constructedQuery = this.entityManager.createQuery(query);
		for (String key : parameters.keySet()) {
			constructedQuery.setParameter(key, parameters.get(key));
		}
		return constructedQuery;
	}
	
	private void executeForPainDiaryResponse(Query constructedQuery) {
		constructedQuery.executeUpdate();
	}
}
