package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.domain.Dateable;

@Entity
@Table(name = "NOTIFICATION")
public class NotificationPo extends PersistenceObject implements Dateable {

	private static final long serialVersionUID = -5356461510681486526L;

	private String body;
	private boolean activeFlag;
	private Date date;
	private Date deletedDate;

	@Id
	@GeneratedValue(generator="notification_id_generator")
	@GenericGenerator(name="notification_id_generator", strategy = "uuid")
	@Column(name = "NOTIFICATION_ID")
	public String getId() {
		return super.getId();
	}

	public void setId(String id) {
		super.setId(id);
	}

	@Column(name = "USER_ID")
	public String getUserId() {
		return super.getUserId();
	}

	public void setUserId(String userId) {
		super.setUserId(userId);
	}

	@Column(name = "BODY")
	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	@Column(name = "ACTIVE")
	public boolean isActiveFlag() {
		return activeFlag;
	}

	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	@Column(name = "CREATED_DATE")
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	@Column(name="DELETED_DATE")
	public Date getDeletedDate() {
		return deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		this.deletedDate = deletedDate;
	}
	
}
