package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import com.agilex.healthcare.mobilehealthplatform.domain.Notification;
import com.agilex.healthcare.mobilehealthplatform.domain.Notifications;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractMapper;

public class NotificationMapper extends AbstractMapper<Notification, Notifications, NotificationPo> {

	public Notification toDto(NotificationPo po) {
		if (po != null) {
			Notification dto = new Notification();

			dto.setUserId(po.getUserId());
			dto.setActiveFlag(po.isActiveFlag());
			dto.setBody(po.getBody());
			dto.setDate(po.getDate());
			dto.setDeletedDate(po.getDeletedDate());
			dto.setNotificationId(po.getId());

			return dto;
		}
		return null;
	}

	public NotificationPo toPo(Notification dto) {
		if (dto != null) {
			NotificationPo po = new NotificationPo();

			po.setUserId(dto.getUserId());
			po.setActiveFlag(dto.isActiveFlag());
			po.setBody(dto.getBody());
			po.setDate(dto.getDate());
			po.setDeletedDate(dto.getDeletedDate());
			po.setId(dto.getNotificationId());

			return po;
		}
		return null;
	}

}
