package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.Notification;
import com.agilex.healthcare.mobilehealthplatform.domain.Notifications;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.utility.NullChecker;

@Service
public class NotificationDataLayerRepo implements NotificationDataLayer {
	
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(NotificationDataLayerRepo.class);
	
	@Resource
	private NotificationDao dao;
	NotificationMapper mapper = new NotificationMapper();

	public Notifications getActiveNotifications(String patientId, DateFilter filter) {
		LOGGER.debug("Getting Notification");
		List<NotificationPo> retrievedNotifications = dao.getActiveNotifications(patientId, filter);
		Notifications retrieved =  mapper.toDtoCollection(retrievedNotifications, new Notifications());
		return retrieved;
	}

	public Notification saveNotification(Notification notification) {
		NotificationPo notificationToSave = mapper.toPo(notification);
//		LOGGER.debug(String.format("Saving Notification Notification with [id: %s][patientId: %s]", notificationToSave.getId(), notificationToSave.getUserId()));
		this.setNotificationDate(notificationToSave);
		
		NotificationPo savedNotification = dao.saveNotification(notificationToSave);
		
		return mapper.toDto(savedNotification);
	}

	public void deleteNotification(Notification notification) {
		LOGGER.debug("Deleting Notification");
		NotificationPo notificationToDelete = mapper.toPo(notification);
		
		dao.deleteNotification(notificationToDelete);
	}

	public Notification getNotification(String userId, String notificationId) {
		LOGGER.debug("Getting Filtered Notifications");
		NotificationPo notification = dao.getActiveNotification(userId, notificationId);
		
		return mapper.toDto(notification);
	}

	private void setNotificationDate(NotificationPo notification) {
		if(NullChecker.isNullish(notification.getDate())) {
			notification.setDate(new Date());
		}
	}
}
