package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="DEVICE_REGISTRATION")
public class DeviceRegistrationPo extends PersistenceObject {
	
	private static final long serialVersionUID = -1973704345366149642L;

	private String deviceToken;
	private Date registeredDate;
	private boolean optedIn;
	private String firstName;
	private String lastName;

	public DeviceRegistrationPo() {}

	@Id
	@GeneratedValue(generator="device_registration_id_generator")
	@GenericGenerator(name="device_registration_id_generator", strategy = "uuid")
	@Column(name="device_registration_id")
	public String getId() {
		return super.getId();
	}
	
	public void setId(String id) {
		super.setId(id);
	}
	
	@Column(name="device_token", nullable = false)
	public String getDeviceToken() {
		return deviceToken;
	}

	public void setDeviceToken(String deviceToken) {
		this.deviceToken = deviceToken;
	}

	@Column(name="user_id")
	public String getUserId() {
		return super.getUserId();
	}

	public void setUserId(String userId) {
		super.setUserId(userId);
	}
	
	@Column(name="registered_date")
	public Date getRegisteredDate() {
		return registeredDate;
	}

	public void setRegisteredDate(Date registeredDate) {
		this.registeredDate = registeredDate;
	}

	@Column(name="opted_in_flag")
	public boolean isOptedIn() {
		return optedIn;
	}

	public void setOptedIn(boolean optedIn) {
		this.optedIn = optedIn;
	}

	@Column(name="first_name")
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	@Column(name="last_name")
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

}
