package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistrations;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractMapper;

public class DeviceRegistrationMapper extends AbstractMapper<DeviceRegistration, DeviceRegistrations, DeviceRegistrationPo> {

	public DeviceRegistration toDto(DeviceRegistrationPo po) {
		if (po != null) {
			DeviceRegistration dto = new DeviceRegistration();

			dto.setPatientId(po.getUserId());
			dto.setOptedIn(po.isOptedIn());
			dto.setDeviceToken(po.getDeviceToken());
			dto.setDeviceRegistrationId(po.getId());
			dto.setFirstName(po.getFirstName());
			dto.setLastName(po.getLastName());
			dto.setRegisteredDate(po.getRegisteredDate());

			return dto;
		}
		return null;
	}

	public DeviceRegistrationPo toPo(DeviceRegistration dto) {
		if (dto != null) {
			DeviceRegistrationPo po = new DeviceRegistrationPo();

			po.setDeviceToken(dto.getDeviceToken());
			po.setFirstName(dto.getFirstName());
			po.setLastName(dto.getLastName());
			po.setId(dto.getDeviceRegistrationId());
			po.setOptedIn(dto.isOptedIn());
			po.setRegisteredDate(dto.getRegisteredDate());
			po.setUserId(dto.getUserId());

			return po;
		}
		return null;
	}

}
