package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.List;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistrations;

public class DeviceRegistrationDataLayerRepo implements DeviceRegistrationDataLayer {

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DeviceRegistrationDataLayerRepo.class);
	private DeviceRegistrationMapper mapper = new DeviceRegistrationMapper();

	@Resource
	private DeviceRegistrationDao dao;

	public DeviceRegistrations getRegistrations(String userId) {
		logger.debug("Getting DeviceRegistration for user");
		List<DeviceRegistrationPo> registrationPos = dao.fetchDeviceRegistrations(userId);
		DeviceRegistrations registrations = new DeviceRegistrations();
		mapper.toDtoCollection(registrationPos, registrations);

		return registrations;
	}

	public DeviceRegistration getRegistration(String deviceRegistrationId) {
		logger.debug("Getting Filtered DeviceRegistrations");
		DeviceRegistration deviceRegistration = mapper.toDto(dao.fetchDeviceRegistrationById(deviceRegistrationId));

		return deviceRegistration;
	}

	public DeviceRegistration getRegistration(String userId, String deviceToken) {
		return mapper.toDto(dao.fetchDeviceRegistration(userId, deviceToken));
	}

	public DeviceRegistration saveRegistration(DeviceRegistration deviceRegistrationToSave) {
		logger.debug("Saving DeviceRegistration");
		DeviceRegistrationPo persistenceDeviceRegistration = mapper.toPo(deviceRegistrationToSave);
		DeviceRegistrationPo savedDeviceRegistration = dao.saveDeviceRegistration(persistenceDeviceRegistration);

		return mapper.toDto(savedDeviceRegistration);
	}

	public void deleteRegistration(DeviceRegistration deviceRegistration) {
		DeviceRegistrationPo persistenceDeviceRegistration = mapper.toPo(deviceRegistration);
		dao.deleteDeviceRegistration(persistenceDeviceRegistration);
	}

	public void deleteRegistration(String deviceToken) {
		logger.debug("Deleting DeviceRegistrations");
		dao.deleteDeviceRegistrationByToken(deviceToken);
		
	}

	public DeviceRegistrations fetchDeviceRegistrations(List<String> userIds) {
		List<DeviceRegistrationPo> deviceRegistrations = dao.fetchDeviceRegistrations(userIds);
		DeviceRegistrations registrations = new DeviceRegistrations();
		return mapper.toDtoCollection(deviceRegistrations, registrations);
	}
	

	public void updateOptStatus(String userId, boolean status) {
		dao.updateOptStatus(userId, status);
	}
}
