package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;

@Entity
@Table(name = MygoalsPo.TABLE_NAME)
@XStreamAlias("MyGoals")
public class MygoalsPo extends PersistenceObject implements Transformable<Mygoals> {

	private static final long serialVersionUID = -8118257077047415212L;

	public static final String TABLE_NAME = "MYGOALS";

	private String id;
	private String inventoryType;
	private String QuestionKey;
	private String answer;
	private Date dateUpdated;
	private Integer elapsedTime;

    public MygoalsPo() {}

    public MygoalsPo(Mygoals dto) {
        setId(dto.getId());
        setUserId(dto.getPatientIdentifier().getUniqueId());
        setInventoryType(dto.getInventoryType());
        setQuestionKey(dto.getQuestionKey());
        setAnswer(dto.getAnswer());
        setDateUpdated(dto.getDateUpdated());
        setElapsedTime(dto.getElapsedTime());
    }

	@Id
	@GeneratedValue(generator = "mygoals_id_generator")
	@GenericGenerator(name = "mygoals_id_generator", strategy = "uuid")
	@Column(name = "MYGOALS_ID", nullable = false)
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}

	@Column(name = "INVENTORY_TYPE")
	public String getInventoryType() {
		return inventoryType;
	}

	public void setInventoryType(String inventoryType) {
		this.inventoryType = inventoryType;
	}
	
	@Column(name = "QUESTION_KEY")
	public String getQuestionKey() {
		return QuestionKey;
	}

	public void setQuestionKey(String questionKey) {
		QuestionKey = questionKey;
	}

	@Column(name = "ANSWER")
	public String getAnswer() {
		return answer;
	}

	public void setAnswer(String answer) {
		this.answer = answer;
	}

	@Column(name = "DATE_UPDATED")
	public Date getDateUpdated() {
		return dateUpdated;
	}

	public void setDateUpdated(Date dateUpdated) {
		this.dateUpdated = dateUpdated;
	}
	
	@Column(name = "ELAPSED_TIME")
	public Integer getElapsedTime() {
		return elapsedTime;
	}

	public void setElapsedTime(Integer elapsedTime) {
		this.elapsedTime = elapsedTime;
	}

	@Override
    public Mygoals create() {
    	Mygoals mygoals = new Mygoals();
    	mygoals.setId(getId());
    	mygoals.setPatientId(getUserId());
    	mygoals.setInventoryType(getInventoryType());
    	mygoals.setQuestionKey(getQuestionKey());
    	mygoals.setAnswer(getAnswer());
    	mygoals.setDateUpdated(getDateUpdated());
    	mygoals.setElapsedTime(getElapsedTime());
        return mygoals;
    }


}
