package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;

@Service
public class MygoalsDataLayerRepo implements MygoalsDataLayer {

	@Resource
	MygoalsDao mygoalsDao;

	@Override
	public MygoalsList fetchLatestMygoalsListByType(String patientId, String inventoryType) {
	
		return mygoalsDao.getLatestMygoalsListByType(patientId, inventoryType);
	}
	
	@Override
	public MygoalsList fetchLatestMygoalsList(String patientId) {
	
		return mygoalsDao.getLatestMygoalsList(patientId);
	}
	
	@Override
	public Mygoals fetchMygoalsById(String patientId, String mygoalsId) {
        return mygoalsDao.get(patientId, mygoalsId);
	}
	
	@Override
	public Mygoals saveMygoals(Mygoals mygoals) {
		return mygoalsDao.save(mygoals);
	}

	@Override
	public MygoalsList fetchMygoalsListByPatient(String patientId) {
		return mygoalsDao.getMygoalsListByPatientId(patientId);
	}

	@Override
	public void deleteMygoals(Mygoals mygoals) {
		mygoalsDao.delete(mygoals);
	}
	
}