package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import java.util.Date;

@Entity
@Table(name = MoodPo.TABLE_NAME)
@XStreamAlias("Mood")
public class MoodPo extends PersistenceObject implements Transformable<MoodEvent> {

    private static final long serialVersionUID = -1825537243252019799L;
    public static final String TABLE_NAME = "MOOD";

    private Date entryDate;
    private String note;
    private String mood;

    public MoodPo() {}

    public MoodPo(MoodEvent dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        setEntryDate(dto.getDate());
        setNote(dto.getNotes());
        setMood(dto.getValue());
    }

    @Id
	@GeneratedValue(generator="mood_id_generator")
	@GenericGenerator(name="mood_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="ENTRY_DATE")
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    @Column(name="NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Column(name="MOOD")
    public String getMood() {
        return mood;
    }

    public void setMood(String mood) {
        this.mood = mood;
    }

    @Override
    public MoodEvent create() {
        MoodEvent event = new MoodEvent();

        event.setUniqueId(getId());
        event.setPatientId(getUserId());
        event.setDate(getEntryDate());
        event.setNotes(getNote());
        event.setValue(getMood());

        return event;

    }
}
