package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

@Service
public class MoodEventDataLayerRepo implements MoodEventDataLayer {

	@Resource
    MoodDao dao;

	public MoodEvents getMoodEvents(String patientId) {
		return dao.get(patientId);
	}

	public MoodEvents getMoodEvents(String patientId, DateFilter filter) {
        return dao.get(patientId, filter);
    }

	public MoodEvent getMoodEvent(String patientId, String eventId) {
        return dao.get(patientId, eventId);
    }

	public MoodEvent saveMoodEvent(MoodEvent moodEvent) {
        return dao.save(moodEvent);
    }

	public void deleteMoodEvent(MoodEvent moodEvent) {
        dao.delete(moodEvent);
	}

}
