package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;
import java.util.*;

@Repository
public class MoodDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MoodDao.class);

    private static final String WHERE_ID_AND_PATIENTID = "from MoodPo where userId = :patientId and id = :id";
    private static final String WHERE_PATIENT_ID = "from MoodPo where userId = :patientId ";

    public MoodEvents get(String patientId) {
        return get(patientId, DateFilterFactory.createEmptyFilter());
    }

    public MoodEvents get(String patientId, DateFilter filter) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Moods info for patient");

        JpaFilter jpaFilter = new JpaDateFilter(filter, "entryDate");
        SimpleEntityManager<MoodPo> simpleEntityManager = new SimpleEntityManager<MoodPo>(WHERE_PATIENT_ID, entityManager);

        List<MoodPo> results = simpleEntityManager.get(patientId, jpaFilter, MoodPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        MoodEvents events = new MoodEvents();
        Mapper.add(transformableList, events);

        return events;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<MoodPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public MoodEvent get(String patientId, String eventId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Mood info for event");

        SimpleEntityManager<MoodPo> simpleEntityManager = new SimpleEntityManager<MoodPo>(WHERE_ID_AND_PATIENTID, entityManager);
        List<MoodPo> results = simpleEntityManager.get(patientId, eventId, MoodPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1)
            logger.warn("Found more than one Mood record");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public MoodEvent save(MoodEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Saving Mood");

        UserHistoryEntityManager<MoodPo> simpleEntityManager = new UserHistoryEntityManager<MoodPo>(entityManager, MoodPo.TABLE_NAME, event);
        MoodPo po = simpleEntityManager.save(new MoodPo(event));

        if (logger.isDebugEnabled()) logger.debug("Saved Mood");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(MoodEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Deleting Mood");

        UserHistoryEntityManager<MoodPo> simpleEntityManager = new UserHistoryEntityManager<MoodPo>(entityManager, MoodPo.TABLE_NAME);
        simpleEntityManager.delete(event, MoodPo.class);
    }
}
