package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import java.util.Date;

import javax.persistence.*;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.MedicationRefillRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = MedicationRefillRequestPo.TABLE_NAME)
@XStreamAlias("MEDICATION_REFILL_REQUEST")
public class MedicationRefillRequestPo extends PersistenceObject implements Transformable<MedicationRefillRequest> {
	
	private static final long serialVersionUID = 3637370384485878183L;

	public static final String TABLE_NAME = "MEDICATION_REFILL_REQUEST";

	private String patientId;
	private Date requestDate;
	private String medicationId;
	
	public MedicationRefillRequestPo() {}
	
	public MedicationRefillRequestPo(MedicationRefillRequest dto) {
		setId(dto.getUniqueId());
		setPatientId(dto.getPatientId());
		setRequestDate(dto.getRequestDate());
		setMedicationId(dto.getMedicationId());
	}
	
	@Id
    @GeneratedValue(generator="refill_id_generator")
    @GenericGenerator(name="refill_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
	public String getId() {
		return super.getId();
	}
	
	@Column(name="PATIENT_ID")
	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	@Column(name="REQUEST_DATE")
	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}
	
	@Column(name="MEDICATION_ID")
	public String getMedicationId() {
		return medicationId;
	}

	public void setMedicationId(String medicationId) {
		this.medicationId = medicationId;
	}

	@Override
	public MedicationRefillRequest create() {
		MedicationRefillRequest refillRequest = new MedicationRefillRequest();
		
		refillRequest.setUniqueId(getId());
		refillRequest.setPatientId(getPatientId());
		refillRequest.setRequestDate(getRequestDate());
		refillRequest.setMedicationId(getMedicationId());
		
		return refillRequest;
	}

}
