package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

import com.agilex.healthcare.mobilehealthplatform.enumeration.RunningMode;

@Embeddable
public class LaunchpadItemPrimaryKey implements Serializable {
	private static final long serialVersionUID = 5608073737611597082L;
	
	String name;
	RunningMode mode;

	@Column(name = "NAME", nullable = false)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Enumerated(EnumType.STRING)
	@Column(name = "ITEM_MODE", nullable = false)
	public RunningMode getMode() {
		return mode;
	}

	public void setMode(RunningMode mode) {
		this.mode = mode;
	}

}
