package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.enumeration.LaunchpadItemType;

@Entity
@Table(name = "LAUNCHPAD_ITEM")
public class LaunchpadItemPo implements Serializable {

	private static final long serialVersionUID = -6188141183980677199L;

	private LaunchpadItemPrimaryKey id;
	private LaunchpadItemType type;
	private String url;
	private String imageUrl;
	private String description;
	private int position;
	private Date instrUpdatedDate;
	private String instruction;
	private String updatedBy;

	@Id
	public LaunchpadItemPrimaryKey getId() {
		return id;
	}

	public void setId(LaunchpadItemPrimaryKey id) {
		this.id = id;
	}
	
	@Enumerated(EnumType.STRING)
	@Column(name = "TYPE", nullable = false)
	public LaunchpadItemType getType() {
		return type;
	}

	public void setType(LaunchpadItemType type) {
		this.type = type;
	}

	@Column(name = "URL", nullable = false)
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Column(name = "IMAGE_URL")
	public String getImageUrl() {
		return imageUrl;
	}

	public void setImageUrl(String imageUrl) {
		this.imageUrl = imageUrl;
	}

	@Column(name = "ITEM_POSITION", nullable = false)
	public int getPosition() {
		return position;
	}

	public void setPosition(int position) {
		this.position = position;
	}

	@Column(name = "DESCRIPTION")
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "INSTR_UPDATED_DATE")
	public Date getInstrUpdatedDate() {
		return instrUpdatedDate;
	}

	public void setInstrUpdatedDate(Date instrUpdatedDate) {
		this.instrUpdatedDate = instrUpdatedDate;
	}

	@Column(name = "INSTRUCTION")
	public String getInstruction() {
		return instruction;
	}

	public void setInstruction(String instruction) {
		this.instruction = instruction;
	}

	@Column(name = "UPDATED_BY")
	public String getUpdatedBy() {
		return updatedBy;
	}

	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}	
}
