package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItem;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItems;

public class LaunchpadItemMapper {
	
	public LaunchpadItems toDto(List<LaunchpadItemPo> pos) {
		LaunchpadItems launchpadItems = new LaunchpadItems();
		for (LaunchpadItemPo po : pos) {
			launchpadItems.add(toDto(po));
		}
		
		return launchpadItems;
	}
	
	public LaunchpadItem toDto(LaunchpadItemPo po) {
		LaunchpadItem dto = new LaunchpadItem();

		dto.setName(po.getId().getName());
		dto.setType(po.getType());
		dto.setDescription(po.getDescription());
		dto.setUrl(po.getUrl());
		dto.setImageUrl(po.getImageUrl());
		dto.setPosition(po.getPosition());
		dto.setInstrUpdatedDate(po.getInstrUpdatedDate());
		dto.setInstruction(po.getInstruction());
		dto.setUpdatedBy(po.getUpdatedBy());
		
		return dto;
	}
}
