package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItem;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItems;
import com.agilex.healthcare.mobilehealthplatform.enumeration.RunningMode;

@Service
public class LaunchpadItemDataLayerRepo implements LaunchpadItemDataLayer{

	private LaunchpadItemMapper mapper = new LaunchpadItemMapper();

	@Resource
	private LaunchpadItemDao dao;
	

	@Override
	public LaunchpadItems fetchLaunchpadItems(RunningMode mode) {
		return mapper.toDto(dao.getLaunchpadItems(mode));
	}
	
	@Override
	public LaunchpadItem fetchLaunchpadItemByUrl(RunningMode mode, String url) {
		LaunchpadItemPo po = dao.getLaunchpadItemByUrl(mode, url);
		if( po != null )
		    return mapper.toDto(dao.getLaunchpadItemByUrl(mode, url));
		else
			return null;
	}
}
