package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.Query;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.enumeration.RunningMode;

@Repository
public class LaunchpadItemDao extends AbstractDao {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(LaunchpadItemDao.class);

	@Transactional(propagation = Propagation.REQUIRED, readOnly = true)
	public List<LaunchpadItemPo> getLaunchpadItems(RunningMode mode) {
		
		Query query = constructWhereClause(mode);
		@SuppressWarnings("unchecked")
		List<LaunchpadItemPo> pos = query.getResultList();
		return pos;
	}
	
	public LaunchpadItemPo getLaunchpadItemByUrl(RunningMode mode, String url) {
		Query query = constructWhereClause(mode, url);
		@SuppressWarnings("unchecked")
		List<LaunchpadItemPo> pos = query.getResultList();
		if( pos != null && pos.size() > 0)
		   return (LaunchpadItemPo)pos.get(0);
		return null;
	}
	
	private Query constructWhereClause(RunningMode mode) {
		StringBuilder whereClause = new StringBuilder();

		Map<String, Object> parameters = new HashMap<String, Object>();

		whereClause.append(" where 1=1 ");
		
		if (mode != null) {
			addModeCriteria(whereClause);
			setModeParameter(mode, parameters);
		}
		
		whereClause.append(" order by position ASC");

		String query = "from LaunchpadItemPo" + whereClause.toString();
		Query constructedQuery = this.setParametersForQuery(query, parameters);
		return constructedQuery;
	}

	private Query constructWhereClause(RunningMode mode, String url) {
		StringBuilder whereClause = new StringBuilder();

		Map<String, Object> parameters = new HashMap<String, Object>();

		whereClause.append(" where 1=1 ");
		
		if (mode != null) {
			addModeCriteria(whereClause);
			setModeParameter(mode, parameters);
		}
		
		if( url != null){
			addUrlCriteria(whereClause);
			setUrlParameter(url, parameters);
		}

		String query = "from LaunchpadItemPo" + whereClause.toString();
		Query constructedQuery = this.setParametersForQuery(query, parameters);
		return constructedQuery;
	}

	private void addModeCriteria(StringBuilder whereClause) {
		whereClause.append(" and id.mode = :mode ");
	}

	private void setModeParameter(RunningMode mode, Map<String, Object> parameters) {
		parameters.put("mode", mode);
	}
	
	private void addUrlCriteria(StringBuilder whereClause) {
		whereClause.append(" and url = :url ");
	}

	private void setUrlParameter(String url, Map<String, Object> parameters) {
		parameters.put("url", url);
	}
	
	private Query setParametersForQuery(String query, Map<String, Object> parameters) {
		//LOGGER.debug(String.format(":::: Query: %s", query));
		Query constructedQuery = this.entityManager.createQuery(query);
		
		for (String key : parameters.keySet()) {
			constructedQuery.setParameter(key, parameters.get(key));
		}
		return constructedQuery;
	}
}
