package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "HEALTH_ADVOCATE_REQUEST")
public class HealthAdvocateRequestPo extends PersistenceObject {

	private static final long serialVersionUID = 2611343283788417974L;

	private String healthAdvocateEDIPI;
	private String uriLinkKey;
	private String email;
	private String firstName;
	private String lastName;
	private String addressFirstLine;
	private String addressSecondLine;
	private String city;
	private String state;
	private String zipCode;
	private String status;
	private Date requestDate;
	private Date lastActionDate;
	private String patientEDIPI;
	private String patientName;
	private String patientDisplayName;
	private String driversLicenseNumber;
	private String driversLicenseState;
	private String ssn;

	@Id
	@GeneratedValue(generator = "health_advocate_id_generator")
	@GenericGenerator(name = "health_advocate_id_generator", strategy = "uuid")
	@Column(name = "HEALTH_ADVOCATE_REQUEST_ID", nullable = false)
	public String getId() {
		return super.getId();
	}

	@Column(name = "HEALTH_ADVOCATE_EDIPI")
	public String getHealthAdvocateEDIPI() {
		return healthAdvocateEDIPI;
	}

	public void setHealthAdvocateEDIPI(String healthAdvocateEDIPI) {
		this.healthAdvocateEDIPI = healthAdvocateEDIPI;
	}

	@Column(name = "PATIENT_EDIPI")
	public String getPatientEDIPI() {
		return patientEDIPI;
	}

	public void setPatientEDIPI(String patientEDIPI) {
		this.patientEDIPI = patientEDIPI;
	}

	@Column(name = "URI_LINK_KEY")
	public String getUriLinkKey() {
		return uriLinkKey;
	}

	public void setUriLinkKey(String uriLinkKey) {
		this.uriLinkKey = uriLinkKey;
	}

	@Column(name = "EMAIL")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@Column(name = "FIRST_NAME")
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	@Column(name = "LAST_NAME")
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	@Column(name = "ADDRESS_FIRST_LINE")
	public String getAddressFirstLine() {
		return addressFirstLine;
	}

	public void setAddressFirstLine(String address) {
		this.addressFirstLine = address;
	}

	@Column(name = "ADDRESS_SECOND_LINE")
	public String getAddressSecondLine() {
		return addressSecondLine;
	}

	public void setAddressSecondLine(String addressSecondLine) {
		this.addressSecondLine = addressSecondLine;
	}

	@Column(name = "CITY")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Column(name = "STATE")
	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	@Column(name = "ZIP_CODE")
	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	@Column(name = "STATUS")
	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Column(name = "REQUEST_DATE")
	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

	@Column(name = "LAST_ACTION_DATE")
	public Date getLastActionDate() {
		return lastActionDate;
	}

	public void setLastActionDate(Date lastActionDate) {
		this.lastActionDate = lastActionDate;
	}

	@Column(name = "Patient_Name")
	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}
	
	@Column(name = "Patient_Display_Name")
	public String getPatientDisplayName() {
		return patientDisplayName;
	}

	public void setPatientDisplayName(String patientDisplayName) {
		this.patientDisplayName = patientDisplayName;
	}

	@Column(name = "DRIVERS_LICENSE_NUMBER")
	public String getDriversLicenseNumber() {
		return driversLicenseNumber;
	}

	public void setDriversLicenseNumber(String driversLicenseNumber) {
		this.driversLicenseNumber = driversLicenseNumber;
	}

	@Column(name = "DRIVERS_LICENSE_STATE")
	public String getDriversLicenseState() {
		return driversLicenseState;
	}

	public void setDriversLicenseState(String driversLicenseState) {
		this.driversLicenseState = driversLicenseState;
	}

	@Column(name = "SSN")
	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

}
