package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractMapper;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequestForm;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;

public class HealthAdvocateRequestMapper extends AbstractMapper<HealthAdvocateRequest, HealthAdvocateRequests, HealthAdvocateRequestPo> {

	private static HealthAdvocateRequestMapper _instance = new HealthAdvocateRequestMapper();
	
	private HealthAdvocateRequestMapper() {
		
	}
	
	public static HealthAdvocateRequestMapper getInstance() {
		return _instance;
	}
	
	public HealthAdvocateRequest toDto(HealthAdvocateRequestPo po) {
		if (po != null) {
			HealthAdvocateRequest dto = new HealthAdvocateRequest();
			
			dto.setUniqueId(po.getId());
			dto.setAddressFirstLine(po.getAddressFirstLine());
			dto.setAddressSecondLine(po.getAddressSecondLine());
			dto.setCity(po.getCity());
			dto.setEmail(po.getEmail());
			dto.setFirstName(po.getFirstName());
			dto.setHealthAdvocateEDIPI(po.getHealthAdvocateEDIPI());
			dto.setLastName(po.getLastName());
			dto.setLastActionDate(po.getLastActionDate());
			dto.setPatientId(po.getPatientEDIPI());
			dto.setRequestDate(po.getRequestDate());
			dto.setState(po.getState());
			dto.setStatus(po.getStatus());
			dto.setUriLinkKey(po.getUriLinkKey());
			dto.setZipCode(po.getZipCode());
			dto.setPatientName(po.getPatientName());
			dto.setPatientDisplayName(po.getPatientDisplayName());
			dto.setDriversLicenseNumber(po.getDriversLicenseNumber());
			dto.setDriversLicenseState(po.getDriversLicenseState());
			dto.setSsn(po.getSsn());
			return dto;
			
		}
		return null;
	}
	
	public HealthAdvocateRequestPo toPo(HealthAdvocateRequest dto) {
		if (dto != null) {
			HealthAdvocateRequestPo po = new HealthAdvocateRequestPo();
			
			po.setId(dto.getUniqueId());
			po.setAddressFirstLine(dto.getAddressFirstLine());
			po.setAddressSecondLine(dto.getAddressSecondLine());
			po.setCity(dto.getCity());
			po.setEmail(dto.getEmail());
			po.setFirstName(dto.getFirstName());
			po.setHealthAdvocateEDIPI(dto.getHealthAdvocateEDIPI());
			po.setLastName(dto.getLastName());
			po.setLastActionDate(dto.getLastActionDate());
			po.setPatientEDIPI(dto.getPatientId());
			po.setRequestDate(dto.getRequestDate());
			po.setState(dto.getState());
			po.setStatus(dto.getStatus());
			po.setUriLinkKey(dto.getUriLinkKey());
			po.setZipCode(dto.getZipCode());
			po.setPatientName(dto.getPatientName());
			po.setPatientDisplayName(dto.getPatientDisplayName());
			po.setDriversLicenseNumber(dto.getDriversLicenseNumber());
			po.setDriversLicenseState(dto.getDriversLicenseState());
			po.setSsn(dto.getSsn());
			
			return po;
		}
		return null;
	}

    public HealthAdvocateRequestFormPo toPo(HealthAdvocateRequestForm dto){
        HealthAdvocateRequestFormPo po = new HealthAdvocateRequestFormPo();
        if (dto != null){
            po.setFormPDF(dto.getFormDataBytes());
            po.setRequest(toPo(dto.getRequest()));
            po.setStatus(dto.getStatus());
            po.setRequestDate(dto.getRequestDate());
            po.setPatientId(dto.getPatientId());
            po.setRequestId(dto.getRequest().getUniqueId());
        }
        return po;
    }

    public HealthAdvocateRequestForm toDto(HealthAdvocateRequestFormPo po) {
        HealthAdvocateRequest request = toDto(po.getRequest());
        HealthAdvocateRequestForm dto = new HealthAdvocateRequestForm(request);

        dto.setFormDataBytes(po.getFormPDF());
        dto.setRequest(toDto(po.getRequest()));
        dto.setStatus(po.getStatus());
        dto.setPatientIdentifier(AssigningAuthorityCode.EDIPI, po.getPatientId());
        dto.setRequestDate(po.getRequestDate());
        return dto;
    }
}
