package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.Date;

import javax.persistence.*;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;

@Entity
@Table(name = "HEALTH_ADVOCATE_FORM")
public class HealthAdvocateRequestFormPo extends PersistenceObject {

	private static final long serialVersionUID = -5989194248265436494L;

	private String requestId;
	private String patientId;
	private Date requestDate;
	private String status;
	private byte[] formPDF;
	private HealthAdvocateRequestPo request;

	public HealthAdvocateRequestFormPo() {
	}

	public HealthAdvocateRequestFormPo(HealthAdvocateRequestPo request) {
		setRequest(request);
	}

	public HealthAdvocateRequestFormPo(HealthAdvocateRequestPo request, byte[] form) {
		this(request);
		setFormPDF(form);
	}

	@Id
	@GeneratedValue(generator = "advocate_request_form_id_generator")
	@GenericGenerator(name = "advocate_request_form_id_generator", strategy = "uuid")
	@Column(name = "ID", nullable = false)
	public String getId() {
		return super.getId();
	}

	@Transient
	public HealthAdvocateRequestPo getRequest() {
		return request;
	}

	public void setRequest(HealthAdvocateRequestPo request) {
		this.request = request;
		setRequestId(request.getId());
		setStatus(request.getStatus());
	}

	@Column(name = "FORM_DATA", nullable = false)
	public byte[] getFormPDF() {
		return formPDF;
	}

	public void setFormPDF(byte[] formPDF) {
		this.formPDF = formPDF;
	}

	@Column(name = "HEALTH_ADVOCATE_REQUEST_ID", nullable = false)
	public String getRequestId() {
		return requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}

	@Column(name = "PATIENT_ID", nullable = false)
	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	@Column(name = "STATUS", nullable = false)
	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatus() {
		return status;
	}

	@Column(name = "REQUEST_DATE", nullable = false)
	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

}
