package com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest;

import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequestForm;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateRequests;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class HealthAdvocateRequestDataLayerRepo implements HealthAdvocateRequestDataLayer {

	@Resource
	HealthAdvocateRequestDao healthAdvocateRequestDao;
	
	HealthAdvocateRequestMapper mapper =  HealthAdvocateRequestMapper.getInstance();
	
	@Override
	public HealthAdvocateRequests fetchHealthAdvocateRequests(String patientId) {
		
		List<HealthAdvocateRequestPo> healthAdvocateRequests = healthAdvocateRequestDao.getHealthAdvocateRequests(patientId);
		
		return mapper.toDtoCollection(healthAdvocateRequests, new HealthAdvocateRequests());
	}

	@Override
	public HealthAdvocateRequest getHealthAdvocate(String patientId, String dataId) {
		
		HealthAdvocateRequestPo healthAdvocateRequestPo = healthAdvocateRequestDao.getHealthAdvocateRequest(patientId, dataId);
		return mapper.toDto(healthAdvocateRequestPo);
	}

	@Override
	public HealthAdvocateRequest createNewHealthAdvocateRequest(HealthAdvocateRequest data) {
		if (NullChecker.isNullish(data.getUniqueId())) {
			setRequestIds(data);
		}
		
		HealthAdvocateRequestPo newHealthAdvocateRequestPo = mapper.toPo(data);
		
		HealthAdvocateRequestPo healthAdvocateRequestPo = healthAdvocateRequestDao.createOrUpdateNewHealthAdvocateRequest(newHealthAdvocateRequestPo);
		
		return mapper.toDto(healthAdvocateRequestPo);
	}

	private void setRequestIds(HealthAdvocateRequest data) {
		data.setHealthAdvocateEDIPI(UUID.randomUUID().toString());
		data.setLastActionDate(DateHelper.getToday());
		data.setRequestDate(DateHelper.getToday());
		data.setUriLinkKey(UUID.randomUUID().toString());
	}

	@Override
	public HealthAdvocateRequest updateHealthAdvocateRequest(HealthAdvocateRequest data) {
		
		
		HealthAdvocateRequestPo updatedHealthAdvocateRequestPo = mapper.toPo(data);
		
		HealthAdvocateRequestPo healthAdvocateRequestPo = healthAdvocateRequestDao.createOrUpdateNewHealthAdvocateRequest(updatedHealthAdvocateRequestPo);
		
		return mapper.toDto(healthAdvocateRequestPo);
	}

    @Override
    public HealthAdvocateRequestForm saveHealthAdvocateRequestForm(HealthAdvocateRequestForm form) {

        HealthAdvocateRequestFormPo healthAdvocateRequestFormPoToSave = mapper.toPo(form);

        HealthAdvocateRequestFormPo savedHealthAdvocateRequestFormPo =  healthAdvocateRequestDao.saveHealthAdvocateRequestForm(healthAdvocateRequestFormPoToSave);
        HealthAdvocateRequestForm savedHealthAdvocateRequestForm =  mapper.toDto(savedHealthAdvocateRequestFormPo);
        return savedHealthAdvocateRequestForm;
    }

}
