package com.agilex.healthcare.mobilehealthplatform.datalayer.feedback;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentProcessedAsPerUserNeed;


@Entity
@Table(name = "USER_FEEDBACK")
public class UserFeedbackPo implements Serializable{
	private static final long serialVersionUID = 1459951628489298815L;

	public UserFeedbackPo() {
	}

	private String uniqueId;
	
	private Date dateCreated;
	
	private String type;

	private AppointmentProcessedAsPerUserNeed appointmentProcessedAsPerUserNeed;
	
	private Integer recommendationRating; 
	
	private String comments;

	@Column(name = "COMMENTS")
	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	@Transient
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "RATING")
	public Integer getRecommendationRating() {
		return recommendationRating;
	}

	public void setRecommendationRating(Integer recommendationRating) {
		this.recommendationRating = recommendationRating;
	}

	@Column(name = "CREATED_DATE")
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	@Id
	@GeneratedValue(generator="user_feedback_id_generator")
	@GenericGenerator(name="user_feedback_id_generator", strategy = "uuid")
	@Column(name = "USER_FEEDBACK_ID")
	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

	@Column(name = "APPT_PROCESSED_TIMELY")
	@Enumerated(EnumType.STRING)
	public AppointmentProcessedAsPerUserNeed getAppointmentProcessedAsPerUserNeed() {
		return appointmentProcessedAsPerUserNeed;
	}

	public void setAppointmentProcessedAsPerUserNeed(
			AppointmentProcessedAsPerUserNeed appointmentProcessedAsPerUserNeed) {
		this.appointmentProcessedAsPerUserNeed = appointmentProcessedAsPerUserNeed;
	}
}
