package com.agilex.healthcare.mobilehealthplatform.datalayer.feedback;

import javax.annotation.Resource;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.UserFeedback;
import com.agilex.healthcare.mobilehealthplatform.datalayer.feedback.UserFeedbackPo;

@Service
public class UserFeedbackDataLayerRepo implements UserFeedbackDataLayer{

	@Resource
	private UserFeedbackDao dao;

	@Override
	public UserFeedback saveUserFeedback(UserFeedback userFeedback) {
		if(userFeedback == null){
			return null;
		}
		UserFeedbackPo userFeedbackPo = toPo(userFeedback); 
		return toDto(dao.saveUserFeedback(userFeedbackPo));
	}

	private UserFeedback toDto(UserFeedbackPo po) {
		UserFeedback dto = new UserFeedback();
		copyProperties(dto, po);
		return dto;
	}

	private UserFeedbackPo toPo(UserFeedback dto) {
		UserFeedbackPo po = new UserFeedbackPo();
		copyProperties(po, dto);
		return po;
	}

	private void copyProperties(Object dest, Object origin){
		try {
			BeanUtils.copyProperties(dest, origin);
		} catch (Exception e) {
			throw new RuntimeException("Unable to copy properties");
		}
	}
}
