package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = FacilityPo.TABLE_NAME)
@XStreamAlias("Facility")
public class FacilityPo extends PersistenceObject implements Transformable<Facility> {

	private static final long serialVersionUID = 5538909130530496964L;
	public static final String TABLE_NAME = "FACILITY";
	private String name;
	private String type;
	private String facilityCode;
	private String state;
	private String city;
	private String address;
	private String parentSiteCode;

	public FacilityPo() {	
	}
	
	public FacilityPo(Facility dto) {
		setFacilityCode(dto.getFacilityCode());
		setName(dto.getName());
		setType(dto.getType());
		setAddress(dto.getAddress());
		setCity(dto.getCity());
		setState(dto.getState());
		setParentSiteCode(dto.getParentSiteCode());
	}
	
	@Column(name = "NAME", unique = true)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	@Id
	@Column(name = "FACILITY_CODE", nullable = false)
	public String getFacilityCode() {
		return facilityCode;
	}

	public void setFacilityCode(String facilityCode) {
		this.facilityCode = facilityCode;
	}

	@Column(name = "STATE")
	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	@Column(name = "CITY")
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	@Column(name = "ADDRESS")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Column(name = "PARENT_SITE_CODE", nullable = false)
	public String getParentSiteCode() {
		return parentSiteCode;
	}

	public void setParentSiteCode(String parentSiteCode) {
		this.parentSiteCode = parentSiteCode;
	}

	@Override
	public Facility create() {
		Facility dto = new Facility();
		dto.setFacilityCode(getFacilityCode());
		dto.setName(getName());
		dto.setType(getType());
		dto.setAddress(getAddress());
		dto.setCity(getCity());
		dto.setState(getState());
		dto.setParentSiteCode(getParentSiteCode());
		
		return dto;
	}
}
