package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

@Service
public class FacilityInternalDataLayerRepo implements FacilityInternalDataLayer{

	@Resource
	private FacilityInternalDao dao;

	@Override
	public Facilities fetchFacilities() {
		return dao.getFacilities();
	}

	@Override
	public Facility fetchFacilityByCode(String code) {
		return dao.getFacilityByCode(code);
	}

	@Override
	public Facility saveFacility(Facility facility) {
		return dao.saveFacility(facility);
	}

	@Override
	public void removeFacility(String facilityCode) {
		dao.removeFacility(facilityCode);
	}
}
