package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

@Repository
public class FacilityInternalDao extends AbstractDao {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(FacilityInternalDao.class);

	public Facilities getFacilities() {
		String selectFacilityPosQuery = "from FacilityPo order by facilityCode";
		Query query = getQuery(selectFacilityPosQuery);
		@SuppressWarnings("unchecked")
		List<FacilityPo> facilityPos = query.getResultList();
		
		Facilities facilities = new Facilities();
		
		for (FacilityPo po : facilityPos) {
			facilities.add(po.create());
		}
		
		return facilities;
	}
	
	public Facility getFacilityByCode(String facilityCode) {
		String selectDetailCodeQuery = "from FacilityPo where facilityCode = :facilityCode";
		Query query = getQuery(selectDetailCodeQuery);
		query.setParameter("facilityCode", facilityCode);
		
		return executeForFacility(query);
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public Facility saveFacility(Facility facility) {
		FacilityPo po = this.entityManager.merge(new FacilityPo(facility));
		
		return (po == null)? null : po.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void removeFacility(String facilityCode) {
		FacilityPo facilityToRemove = this.entityManager.find(FacilityPo.class, facilityCode);
		this.entityManager.remove(facilityToRemove);
	}
	
	private Facility executeForFacility(Query query) {
		try {
			FacilityPo po = (FacilityPo) query.getSingleResult();
			return po.create();
		} catch (NoResultException e) {
			throw new WebApplicationException(Status.NOT_FOUND);
		} catch (NonUniqueResultException e) {
			throw new WebApplicationException(Status.PRECONDITION_FAILED);
		}
	}

	private Query getQuery(String dbQuery) {
		Query query = this.entityManager.createQuery(dbQuery);
		return query;
	}

}
