package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = ExercisePo.TABLE_NAME)
@XStreamAlias("Exercise")
public class ExercisePo extends PersistenceObject implements Transformable<Exercise> {
    private static final long serialVersionUID = -7229581299935457799L;
    public static final String TABLE_NAME = "EXERCISE";

    private int duration;
    private double distance;
    private String intensity;
    private String activity;
    private Date activityDate;
    private String note;

    public ExercisePo() {}

    public ExercisePo(Exercise dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        activity = dto.getActivity();
        activityDate = dto.getDate();
        distance = dto.getDistance();
        duration = dto.getDuration();
        intensity = dto.getIntensity();
        note = dto.getNotes();
    }

    @Id
    @GeneratedValue(generator="exercise_id_generator")
    @GenericGenerator(name="exercise_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="DURATION")
    public int getDuration() {
        return duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Column(name="DISTANCE")
    public double getDistance() {
        return distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Column(name="INTENSITY")
    public String getIntensity() {
        return intensity;
    }

    public void setIntensity(String intensity) {
        this.intensity = intensity;
    }

    @Column(name="ACTIVITY")
    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    @Column(name="ACTIVITY_DATE")
    public Date getActivityDate() {
        return activityDate;
    }

    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    @Column(name="NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public Exercise create() {
        Exercise exercise = new Exercise();

        exercise.setUniqueId(getId());
        exercise.setPatientId(getUserId());
        exercise.setActivity(activity);
        exercise.setDate(activityDate);
        exercise.setDistance(distance);
        exercise.setDuration(duration);
        exercise.setIntensity(intensity);
        exercise.setNotes(note);

        return exercise;
    }
}
