package com.agilex.healthcare.mobilehealthplatform.datalayer.exercise;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.datalayer.exercise.ExerciseDao;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.datalayer.exercise.ExerciseDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercise;
import com.agilex.healthcare.mobilehealthplatform.domain.Exercises;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

@Service
public class ExerciseDataLayerRepo implements ExerciseDataLayer {
	@Resource
    ExerciseDao dao;
	
	public Exercises getExercises(String patientId) {
		return dao.get(patientId);
	}

	public Exercises getExercises(String patientId, DateFilter filter) {
		return dao.get(patientId, filter);
	}

	public Exercise getExercise(String patientId, String exerciseId) {
		return dao.get(patientId, exerciseId);
	}

	public Exercise saveExercise(Exercise exercise) {
		return dao.save(exercise);
	}

	public void deleteExercise(Exercise exercise) {
		dao.delete(exercise);
	}

}
