package com.agilex.healthcare.mobilehealthplatform.datalayer.event;

import com.agilex.healthcare.mobilehealthplatform.domain.DailyEvent;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = DailyEventPo.TABLE_NAME)
@XStreamAlias("DailyEvent")
public class DailyEventPo extends PersistenceObject implements Transformable<DailyEvent> {
    private static final long serialVersionUID = -7813436359996820246L;
    public static final String TABLE_NAME = "DAILY_EVENT";

    private String title;
    private Date entryDate;
    private String note;

    public DailyEventPo() {}

    public DailyEventPo(DailyEvent dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        setEntryDate(dto.getEntryDate());
        setTitle(dto.getTitle());
        setNote(dto.getNotes());
    }

    @Id
    @GeneratedValue(generator="daily_event_id_generator")
    @GenericGenerator(name="daily_event_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="TITLE")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="ENTRY_DATE")
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    @Column(name="NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public DailyEvent create() {
        DailyEvent event = new DailyEvent();

        event.setUniqueId(getId());
        event.setPatientId(getUserId());
        event.setEntryDate(getEntryDate());
        event.setTitle(getTitle());
        event.setNotes(getNote());

        return event;
    }
}
