package com.agilex.healthcare.mobilehealthplatform.datalayer.event;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dailyevents.DailyEventDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.event.DailyEventDao;
import org.springframework.stereotype.Service;

@Service
public class DailyEventDataLayerRepo implements DailyEventDataLayer {

	@Resource
    DailyEventDao dao;

	public DailyEvent getDailyEvent(String patientId, String eventId) {
		return dao.get(patientId, eventId);
	}

	public DailyEvents getDailyEvents(String patientId) {
        return dao.get(patientId);
	}

	public DailyEvents getDailyEvents(String patientId, DateFilter filter) {
        return dao.get(patientId, filter);
	}

	public DailyEvent saveDailyEvent(DailyEvent dailyEvent) {
        return dao.save(dailyEvent);
	}

	public void deleteDailyEvent(DailyEvent dailyEvent) {
        dao.delete(dailyEvent);
	}
}
