package com.agilex.healthcare.mobilehealthplatform.datalayer.event;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

@Repository
public class DailyEventDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DailyEventDao.class);

    private static final String WHERE_ID = "from DailyEventPo where userId = :patientId and id = :id";
    private static final String WHERE_PATIENT_ID = "from DailyEventPo where userId = :patientId ";

    public DailyEvents get(String patientId) {
        return get(patientId, DateFilterFactory.createEmptyFilter());
    }

    public DailyEvents get(String patientId, DateFilter filter) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving DailyEvents info for a patient");

        JpaFilter jpaFilter = new JpaDateFilter(filter, "entryDate");
        SimpleEntityManager<DailyEventPo> simpleEntityManager = new SimpleEntityManager<DailyEventPo>(WHERE_PATIENT_ID, entityManager);

        List<DailyEventPo> results = simpleEntityManager.get(patientId, jpaFilter, DailyEventPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        DailyEvents events = new DailyEvents();
        Mapper.add(transformableList, events);

        return events;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<DailyEventPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public DailyEvent get(String patientId, String eventId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving DailyEvent info for an event");

        SimpleEntityManager<DailyEventPo> simpleEntityManager = new SimpleEntityManager<DailyEventPo>(WHERE_ID, entityManager);
        List<DailyEventPo> results = simpleEntityManager.get(patientId, eventId, DailyEventPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1)
            logger.warn("Found more than one DailyEvent record");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public DailyEvent save(DailyEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Saving DailyEvent");

        UserHistoryEntityManager<DailyEventPo> simpleEntityManager = new UserHistoryEntityManager<DailyEventPo>(entityManager, DailyEventPo.TABLE_NAME, event);
        DailyEventPo po = simpleEntityManager.save(new DailyEventPo(event));

        if (logger.isDebugEnabled()) logger.debug("Saved DailyEvent");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(DailyEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Deleting DailyEvent");

        UserHistoryEntityManager<DailyEventPo> simpleEntityManager = new UserHistoryEntityManager<DailyEventPo>(entityManager, DailyEventPo.TABLE_NAME);
        simpleEntityManager.delete(event, DailyEventPo.class);
    }
}
