package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.net.*;

@Entity
@Table(name = "DOCUMENTS")
public class DocumentPo extends PersistenceObject implements Transformable<Document> {

	private static final long serialVersionUID = -7347625045034515484L;

	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DocumentPo.class);

	private String entryId;
	private String title;
	private String classCode;
	private String mimeType;
	private String uri;
	private byte[] document;

	public DocumentPo() {
	}

	public DocumentPo(Document dto) {

		setId(dto.getUniqueId());
		setUserId(dto.getPatientId());
		setClassCode(dto.getClassCode());
		setTitle(dto.getDocumentTitle());
		setMimeType(dto.getMimeType());

		if (dto.getParentData() != null)
			setEntryId(dto.getParentData().getUniqueId());
		if (dto.getBody() != null) {
			setDocument(dto.getBody().getContents());
			if (dto.getBody().getUri() != null)
				setUri(dto.getBody().getUri().toString());
		}

	}

	@Id
	@GeneratedValue(generator = "document_id_generator")
	@GenericGenerator(name = "document_id_generator", strategy = "uuid")
	@Column(name = "ID", nullable = false)
	public String getId() {
		return super.getId();
	}

	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}

	@Column(name = "ENTRY_ID")
	public String getEntryId() {
		return entryId;
	}

	public void setEntryId(String entryId) {
		this.entryId = entryId;
	}

	@Column(name = "TITLE")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "CLASS_CODE")
	public String getClassCode() {
		return classCode;
	}

	public void setClassCode(String classCode) {
		this.classCode = classCode;
	}

	@Column(name = "MIME_TYPE")
	public String getMimeType() {
		return mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

	@Column(name = "URI")
	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	@Column(name = "DOCUMENT")
	public byte[] getDocument() {
		return document;
	}

	public void setDocument(byte[] document) {
		this.document = document;
	}

	@Override
	public Document create() {
		Document doc = new Document();

		doc.setId(getId());
		doc.setClassCode(getClassCode());
		doc.setDocumentTitle(getTitle());
		doc.setPatientId(getUserId());
		doc.setMimeType(getMimeType());
		doc.getBody().setContents(getDocument());
		setEntryId(doc);
		setURI(doc);

		return doc;
	}

	private void setEntryId(Document doc) {
		RelatedDataItem relatedDataItem = new RelatedDataItem();
		relatedDataItem.setUniqueId(getEntryId());
		doc.setParentData(relatedDataItem);

	}

	private void setURI(Document doc) {
		if(getUri() == null)
			return;
		
		try {
			doc.getBody().setUri(new URI(getUri()));
		} catch (URISyntaxException e) {
			if (getUri() != null)
				logger.debug("Unable to create a URI for document", e);
			else
				logger.debug("Unable to create a URI for document", e);
		}
	}
}
