package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.JpaFilter;

import javax.persistence.TypedQuery;

public class DocumentJpaFilter implements JpaFilter {
    private String entryId;
    private String title;

    public DocumentJpaFilter(DocumentFilter filter) {
        if (filter == null)
            return;

        if (filter.getParentItem() == null)
            entryId = null;
        else
            entryId = filter.getParentItem().getUniqueId();

        title = filter.getDocumentTitle();
    }

    public String createFilterQueryStr(String baseQuery) {
        StringBuilder builder = new StringBuilder(baseQuery);

        if (entryId != null)
            builder.append(" and entryId = :entryId");

        if (title != null)
            builder.append(" and title = :title");

        return builder.toString();
    }

    public void addFilterParameters(TypedQuery<?> query) {
        if (entryId != null)
            query.setParameter("entryId", entryId);

        if (title != null)
            query.setParameter("title", title);
    }
}
