package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDao;

@Service
public class DocumentDataLayerRepo implements DocumentDataLayer {

	@Resource
	DocumentDao dao;

	public Documents fetchDocuments(String patientId, DocumentFilter filter) {
		return dao.get(patientId, filter);
	}

	public Document fetchDocument(String patientId, String documentId) {
		return dao.get(patientId, documentId);
	}

	public Document saveDocument(Document document) {
		return dao.save(document);
	}

	public void deleteDocument(Document document) {
		dao.delete(document);
	}
}
