package com.agilex.healthcare.mobilehealthplatform.datalayer.document;

import java.util.ArrayList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.SimpleEntityManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Mapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.domain.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.Documents;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;

@Repository
public class DocumentDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DocumentDao.class);

    private static final String WHERE_ID = "from DocumentPo where userId = :patientId and id = :id";
    private static final String WHERE_PATIENT_ID = "from DocumentPo where userId = :patientId ";

    public Documents get(String patientId) {
        return get(patientId, new DocumentFilter());
    }

    public Documents get(String patientId, DocumentFilter filter) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Documents for a patient");

        DocumentJpaFilter documentFilter = new DocumentJpaFilter(filter);
        SimpleEntityManager<DocumentPo> simpleEntityManager = new SimpleEntityManager<DocumentPo>(WHERE_PATIENT_ID, entityManager);

        List<DocumentPo> results = simpleEntityManager.get(patientId, documentFilter, DocumentPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        Documents documents = new Documents();
        Mapper.add(transformableList, documents);

        return documents;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<DocumentPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public Document get(String patientId, String documentId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Document");
        

        SimpleEntityManager<DocumentPo> simpleEntityManager = new SimpleEntityManager<DocumentPo>(WHERE_ID, entityManager);
        List<DocumentPo> results = simpleEntityManager.get(patientId, documentId, DocumentPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1)
            logger.warn("Found more than one Document record");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public Document save(Document document) {
        if (logger.isDebugEnabled()) logger.debug("Saving Document");

        SimpleEntityManager<DocumentPo> simpleEntityManager = new SimpleEntityManager<DocumentPo>(entityManager);
        DocumentPo po = new DocumentPo(document);
        po = simpleEntityManager.save(po);

        if (logger.isDebugEnabled()) logger.debug("Saved Document");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(Document document) {
        if (logger.isDebugEnabled()) logger.debug("Deleting Document");

        SimpleEntityManager<DocumentPo> simpleEntityManager = new SimpleEntityManager<DocumentPo>(entityManager);
        simpleEntityManager.delete(document, DocumentPo.class);
    }
}
