package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import com.agilex.healthcare.mobilehealthplatform.domain.DietEntry;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.utility.MealType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = DietEntryPo.TABLE_NAME)
@XStreamAlias("Diet")
public class DietEntryPo extends PersistenceObject implements Transformable<DietEntry> {
    private static final long serialVersionUID = -3114476675550527829L;
    public static final String TABLE_NAME = "DIET";

    private String mealType;
    private String calories;
    private String fat;
    private String carbs;
    private String protein;
    private Date entryDate;
    private String note;

    public DietEntryPo() {}

    public DietEntryPo(DietEntry dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        setCalories(dto.getCalories());
        setEntryDate(dto.getEntryDate());
        setCarbs(dto.getCarbs());
        setFat(dto.getFat());
        setMealType(dto.getMealType().toString());
        setNote(dto.getNotes());
        setProtein(dto.getProtein());
    }

    @Id
    @GeneratedValue(generator="diet_id_generator")
    @GenericGenerator(name="diet_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="MEAL_TYPE")
    public String getMealType() {
        return mealType;
    }

    public void setMealType(String mealType) {
        this.mealType = mealType;
    }

    @Column(name="CALORIES")
    public String getCalories() {
        return calories;
    }

    public void setCalories(String calories) {
        this.calories = calories;
    }

    @Column(name="FAT")
    public String getFat() {
        return fat;
    }

    public void setFat(String fat) {
        this.fat = fat;
    }

    @Column(name="CARBS")
    public String getCarbs() {
        return carbs;
    }

    public void setCarbs(String carbs) {
        this.carbs = carbs;
    }

    @Column(name="PROTEIN")
    public String getProtein() {
        return protein;
    }

    public void setProtein(String protein) {
        this.protein = protein;
    }

    @Column(name="ENTRY_DATE")
    public Date getEntryDate() {
        return entryDate;
    }

    public void setEntryDate(Date entryDate) {
        this.entryDate = entryDate;
    }

    @Column(name="NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public DietEntry create() {
        DietEntry entry = new DietEntry();

        entry.setUniqueId(getId());
        entry.setPatientId(getUserId());
        entry.setCalories(getCalories());
        entry.setCarbs(getCarbs());
        entry.setEntryDate(getEntryDate());
        entry.setFat(getFat());
        entry.setMealType(MealType.fromValue(getMealType()));
        entry.setNotes(getNote());
        entry.setProtein(getProtein());

        return entry;
    }
}

