package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.diet.DietDao;
import org.springframework.stereotype.Service;

@Service
public class DietDataLayerRepo implements DietDataLayer {

	@Resource
	DietDao dietDao;

	public DietEntry getDietEntry(String patientId, String dietId) {
		return dietDao.get(patientId, dietId);
	}

	public DietEntries getDietEntries(String patientId) {
		return dietDao.get(patientId);
	}

	public DietEntries getDietEntries(String patientId, DateFilter filter) {
		return dietDao.get(patientId, filter);
	}

	public DietEntry saveDietEntry(DietEntry dietEntry) {
		return dietDao.save(dietEntry);
	}

	public void deleteDietEntry(DietEntry dietEntry) {
		dietDao.delete(dietEntry);
	}

}
