package com.agilex.healthcare.mobilehealthplatform.datalayer.diet;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

@Repository
public class DietDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DietDao.class);

    private static final String WHERE_ID = "from DietEntryPo where userId = :patientId and id = :id";
    private static final String WHERE_PATIENT_ID = "from DietEntryPo where userId = :patientId ";

    public DietEntries get(String patientId) {
        return get(patientId, DateFilterFactory.createEmptyFilter());
    }

    public DietEntries get(String patientId, DateFilter filter) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving DietEntries info for a ßpatient");

        JpaFilter jpaFilter = new JpaDateFilter(filter, "entryDate");
        SimpleEntityManager<DietEntryPo> simpleEntityManager = new SimpleEntityManager<DietEntryPo>(WHERE_PATIENT_ID, entityManager);

        List<DietEntryPo> results = simpleEntityManager.get(patientId, jpaFilter, DietEntryPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        DietEntries entries = new DietEntries();
        Mapper.add(transformableList, entries);

        return entries;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<DietEntryPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public DietEntry get(String patientId, String eventId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving DietEntry info for an event");

        SimpleEntityManager<DietEntryPo> simpleEntityManager = new SimpleEntityManager<DietEntryPo>(WHERE_ID, entityManager);
        List<DietEntryPo> results = simpleEntityManager.get(patientId, eventId, DietEntryPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1)
            logger.warn("Found more than one DietEntry record");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public DietEntry save(DietEntry entry) {
        if (logger.isDebugEnabled()) logger.debug("Saving DietEntry");

        UserHistoryEntityManager<DietEntryPo> simpleEntityManager = new UserHistoryEntityManager<DietEntryPo>(entityManager, DietEntryPo.TABLE_NAME, entry);
        DietEntryPo po = simpleEntityManager.save(new DietEntryPo(entry));

        if (logger.isDebugEnabled()) logger.debug("Saved DietEntry");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(DietEntry entry) {
        if (logger.isDebugEnabled()) logger.debug("Deleting DietEntry");

        UserHistoryEntityManager<DietEntryPo> simpleEntityManager = new UserHistoryEntityManager<DietEntryPo>(entityManager, DietEntryPo.TABLE_NAME);
        simpleEntityManager.delete(entry, DietEntryPo.class);
    }
}
