package com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog;

import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.domain.ContactLog;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import java.util.Date;

@Entity
@Table(name = ContactLogPo.TABLE_NAME)
@XStreamAlias("ContactLog")
public class ContactLogPo extends PersistenceObject implements Transformable<ContactLog> {
    private static final long serialVersionUID = 5235051791130036958L;

    public static final String TABLE_NAME = "COMMUNICATIONS";

    private Date logTime;
    private String contact;
    private String contactType;
    private String subject;
    private String note;

    public ContactLogPo() {}

    public ContactLogPo(ContactLog dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        setLogTime(dto.getLogTime());
        setNote(dto.getNote());
        setContact(dto.getContact());
        setContactType(dto.getActivity());
        setSubject(dto.getTask());
    }

    @Id
	@GeneratedValue(generator="contact_log_id_generator")
	@GenericGenerator(name="contact_log_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="LOG_TIME")
    public Date getLogTime() {
        return logTime;
    }

    public void setLogTime(Date logTime) {
        this.logTime = logTime;
    }

    @Column(name="CONTACT")
    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    @Column(name="CONTACT_TYPE")
    public String getContactType() {
        return contactType;
    }

    public void setContactType(String contactType) {
        this.contactType = contactType;
    }

    @Column(name="SUBJECT")
    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Column(name="NOTE")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public ContactLog create() {
        ContactLog log = new ContactLog();

        log.setUniqueId(getId());
        log.setPatientId(getUserId());
        log.setLogTime(getLogTime());
        log.setActivity(getContactType());
        log.setContact(getContact());
        log.setNote(getNote());
        log.setTask(getSubject());

        return log;
    }
}
