package com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.ContactLog;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLogs;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog.ContactLogDao;
import org.springframework.stereotype.Service;

@Service
public class ContactLogDataLayerRepo implements ContactLogDataLayer {

	@Resource
	ContactLogDao contactLogDao;

	public ContactLog getContactLog(String patientId, String contactLogId) {
		return contactLogDao.get(patientId, contactLogId);
	}

	public ContactLogs getContactLogs(String patientId) {
		return contactLogDao.get(patientId);
	}

	public ContactLogs getContactLogs(String patientId, DateFilter filter) {
		return contactLogDao.get(patientId, filter);
	}

	public ContactLog saveContactLog(ContactLog contactLog) {
		return contactLogDao.save(contactLog);
	}

	public void deleteContactLog(ContactLog contactLog) {
		contactLogDao.delete(contactLog);
	}

}
