package com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory.UserHistoryEntityManager;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

@Repository
public class ContactLogDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ContactLogDao.class);

    private static final String WHERE_ID = "from ContactLogPo where userId = :patientId and id = :id";
    private static final String WHERE_PATIENT_ID = "from ContactLogPo where userId = :patientId ";

    public ContactLogs get(String patientId) {
        return get(patientId, DateFilterFactory.createEmptyFilter());
    }

    public ContactLogs get(String patientId, DateFilter filter) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving ContactLog info for patient");

        JpaFilter jpaFilter = new JpaDateFilter(filter, "logTime");
        SimpleEntityManager<ContactLogPo> simpleEntityManager = new SimpleEntityManager<ContactLogPo>(WHERE_PATIENT_ID, entityManager);

        List<ContactLogPo> results = simpleEntityManager.get(patientId, jpaFilter, ContactLogPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        ContactLogs logs = new ContactLogs();
        Mapper.add(transformableList, logs);

        return logs;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<ContactLogPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public ContactLog get(String patientId, String eventId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving ContactLog info for event");

        SimpleEntityManager<ContactLogPo> simpleEntityManager = new SimpleEntityManager<ContactLogPo>(WHERE_ID, entityManager);
        List<ContactLogPo> results = simpleEntityManager.get(patientId, eventId, ContactLogPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1)
            logger.warn("Found more than one ContactLog record");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public ContactLog save(ContactLog log) {
        if (logger.isDebugEnabled()) logger.debug("Saving ContactLog");

        UserHistoryEntityManager<ContactLogPo> simpleEntityManager = new UserHistoryEntityManager<ContactLogPo>(entityManager, ContactLogPo.TABLE_NAME, log);
        ContactLogPo po = simpleEntityManager.save(new ContactLogPo(log));

        if (logger.isDebugEnabled()) logger.debug("Saved ContactLog with");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(ContactLog log) {
        if (logger.isDebugEnabled()) logger.debug("Deleting ContactLog");

        UserHistoryEntityManager<ContactLogPo> simpleEntityManager = new UserHistoryEntityManager<ContactLogPo>(entityManager, ContactLogPo.TABLE_NAME);
        simpleEntityManager.delete(log, ContactLogPo.class);
    }
}
