package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientPublicKey;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "PUBLIC_KEY")
public class PatientPublicKeyPo extends PersistenceObject implements Transformable<PatientPublicKey> {
    private static final long serialVersionUID = 3386452536740356176L;

    public PatientPublicKeyPo() {}

    public PatientPublicKeyPo(PatientPublicKey dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
    }

    @Id
    @GeneratedValue(generator="patient_public_key_id_generator")
    @GenericGenerator(name="patient_public_key_id_generator", strategy = "uuid")
    @Column(name="PUBLIC_KEY")
    public String getId() {
        return super.getId();
    }

    @Column(name="USER_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Override
    public PatientPublicKey create() {
        return new PatientPublicKey(getId(), getUserId());
    }
}
